@ECHO OFF
REM
ECHO Setzen der Zeitstempel von DNG-Bilddateien auf Aufnahmezeitpunkt - v1.01
ECHO Copyright (c) 2006 Sven Hader
ECHO.
ECHO Aufrufsyntax: set_exdate_dng ^<cr2_verzeichnis^> ^<dng_verzeichnis^> 
ECHO.
ECHO Dieses Stapelverarbeitungsprogramm setzt alle Zeitstempel ('erzeugt am',
ECHO 'geaendert am', 'zuletzt zugegriffen am') einer Anzahl von DNG-Bilddateien
ECHO (DNG: standardisiertes Raw-Format von Adobe) auf den Aufnahmezeitpunkt des
ECHO Fotos. Dabei gelten folgende Annahmen:
ECHO   + Das Programm 'file_tstmp.exe' befindet sich im Aufrufverzeichnis oder
ECHO     in einem im Suchpfad enthaltenen Verzeichnis.
ECHO   + Alle DNG-Dateien befinden sich im selben Verzeichnis ^<dng_verzeichnis^>.
ECHO   + Die Original-Bilddateien im CR2-Raw-Format befinden sich in einem
ECHO     Verzeichnis ^<cr2_verzeichnis^> und besitzen dieselben Namen wie die
ECHO     zugehoerigen DNG-Dateien (bis auf die Extension).
REM      Auch andere Raw-Formate koennen verwendet werden, wenn man den
REM      untenstehenden Aufruf von 'file_tstmp' entsprechend anpasst!
ECHO   + Der 'geaendert am'-Zeitstempel der CR2-Dateien repraesentiert den
ECHO     Aufnahmezeitpunkt des Fotos.
REM      Diese Annahme trifft (mit einer geringen Abweichung von 1-3 sec) nach
REM      dem Kopieren der CR2-Datei zu (solange diese nicht modifiziert wird)!
ECHO.
ECHO ACHTUNG: Das Setzen der Zeitstempel kann nicht zurueckgenommen werden!
ECHO.
REM %1 und %2 im IF mit ~, da sonst Probleme mit Dateinamen, die (z.B. wegen
REM Leerzeichen) in Anfuehrungszeichen angegeben werden
IF NOT EXIST "%~1" GOTO fehler
IF NOT EXIST "%~2" GOTO fehler
SET /P i=Sollen die Zeitstempel gesetzt werden [j/n]:
IF /I NOT "%i%"=="j" GOTO abbruch
ECHO.
SET /A n = 0
REM %2 im FOR mit ~, da sonst Probleme mit Dateinamen, die (z.B. wegen
REM Leerzeichen) in Anfuehrungszeichen angegeben werden
FOR %%d IN ("%~2"\*.dng) DO (
IF EXIST "%1\%%~nd.cr2" (
REM Um nicht alle sondern nur bestimmte Zeitstempel auf den Aufnahmezeitpunkt
REM zu setzen, kann 'mmm' entsprechend angepasst werden.
file_tstmp -c -m -a -f "%1\%%~nd.cr2" -F mmm -s "%%d"
IF errorlevel 1 (
ECHO [OK]  %1\%%~nd.cr2 -^> %%d
SET /A n += 1
) ELSE ECHO [ERR] %1\%%~nd.cr2 -^> %%d
)
)
ECHO.
ECHO Zeitstempel von %n% Dateien gesetzt
GOTO ende
:fehler
ECHO Entweder wurden bei Aufruf des Programms die Namen der beiden Verzeichnisse
ECHO nicht angegeben oder mindestens eines der Verzeichnisse existiert nicht!
GOTO ende
:abbruch
ECHO.
ECHO Abbruch durch Nutzer
ECHO.
:ende